<?php
defined('BASEPATH') OR exit('No direct script access allowed');

require APPPATH . '/libraries/REST_Controller.php';

class Campaign extends REST_Controller {

	/**
	 * Index Page for this controller.
	 *
	 * Maps to the following URL
	 * 		http://example.com/index.php/welcome
	 *	- or -
	 * 		http://example.com/index.php/welcome/index
	 *	- or -
	 * Since this controller is set as the default controller in
	 * config/routes.php, it's displayed at http://example.com/
	 *
	 * So any other public methods not prefixed with an underscore will
	 * map to /index.php/welcome/<method_name>
	 * @see https://codeigniter.com/user_guide/general/urls.html
	 */
    

	public function index_get()
	{
        show_404();
	}
	
	public function webform_get()
	{
        $this->load->view('webservice_form');
	}
	
	public function insert_post()
	{
	    $res_Arr=[];
        $msg='';
        
        $input = $this->input->post();
        
        $this->form_validation->set_data($input);
 	    $this->form_validation->set_rules('device_type', 'device_type', 'trim|xss_clean|required');
 	    $this->form_validation->set_rules('udid', 'udid', 'trim|xss_clean|required');
 	    $this->form_validation->set_rules('referer', 'referer', 'trim|xss_clean|required');
 	    $this->form_validation->set_rules('package_name', 'package_name', 'trim|xss_clean|required');
 	    $this->form_validation->set_rules('is_dev_or_prod', 'is_dev_or_prod', 'trim|xss_clean');
 	    $this->form_validation->set_rules('app_version', 'app_version', 'trim|xss_clean');
 	    
 	    
        if($this->form_validation->run() === false) {
            //validation msg
           $msg = implode(',',$this->form_validation->error_array());
        }
        else{
            
            $input_arr = (object) array(
               'device_type'    => trim( $this->input->post('device_type',TRUE) ),
               'udid'           => trim( $this->input->post('udid',TRUE) ),
               'referer'        => trim( $this->input->post('referer',TRUE)),
               'package_name'   => trim( $this->input->post('package_name',TRUE)),
               'is_dev_or_prod' => trim( $this->input->post('is_dev_or_prod',TRUE)),
               'app_version'    => trim( $this->input->post('app_version',TRUE)),
            );
            
            // var_dump($input_arr);
            // exit;
            
            unset($input);
           
            if( !empty($input_arr->package_name) && !empty($input_arr->device_type) && !empty($input_arr->udid) &&
            !empty($input_arr->referer) ){
                
                $this->load->model('campaign_model');
                 
                $res_data = $this->campaign_model->save_data($input_arr);
            //    var_dump($res_data);
            //    exit;
                if(!empty($res_data)){
                    if($res_data['res'] && !empty($res_data['data'] )){
                        $res_Arr = $res_data['data'];
                        $msg = 'succuss';
                    }
                    else{
                        $msg = $res_data['msg'];
                   }
                   
                   unset($res_data);
                   
                }else{
                   $msg = 'Insertion failed';
                }
               
            }else{

               $msg = 'Package name OR Device type OR UDID OR Referer value was empty';
            }
        
        }
       
       
       //finally check  $res_Arr is ready or not if not set msg
       if(!empty($res_Arr)){
           $response_Arr = array('result' => "1", "msg" => $msg );
       }else{
           $response_Arr = array('result' => "0", "msg" => $msg );
       }
       
       //finally sent the response array as json
       $this->response($response_Arr, REST_Controller::HTTP_OK);
       
	}
	
}
