<!DOCTYPE html>
<html lang="en">
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1"/>
    <meta content="width=device-width, initial-scale=1.0" name="viewport">
    <meta name="apple-mobile-web-app-capable" content="yes">
    
    <title><?php echo ($page_title);?></title>
    <link rel="canonical" href="<?php echo ($canonical_link);?>" />
    
    <meta name="title" content="<?php echo $page_title;?>">
    <meta name="description" content="<?php echo $meta_description;?>"/>
    <meta name="keywords" content="<?php echo $meta_description;?>">
    <!-- Facebook Meta Tags -->
    <meta property="og:url" content="<?php echo $page_title;?>">
    <meta property="og:title" content="<?php echo $page_title;?>">
    <meta property="og:description" content="<?php echo $meta_description;?>">
    <meta property="og:type" content="website">
    <meta property="og:locale" content="en_US"/>
    
    <!-- Favicons -->
    <link id="favicon" rel="shortcut icon" href="<?php echo $fav_icon_url;?>">
  
    <!-- Google Fonts -->
    <link href="https://fonts.googleapis.com/css?family=Open+Sans:300,300i,400,400i,600,600i,700,700i|Nunito:300,300i,400,400i,600,600i,700,700i|Poppins:300,300i,400,400i,500,500i,600,600i,700,700i" rel="stylesheet">

    <!-- Vendor CSS Files -->
    <link href="<?php echo base_url();?>assets/vendor/bootstrap/css/bootstrap.min.css" rel="stylesheet">
    <link href="<?php echo base_url();?>assets/vendor/bootstrap-icons/bootstrap-icons.css" rel="stylesheet">
    <!-- Main CSS File -->
    <link href="<?php echo base_url(); ?>assets/css/style.css" rel="stylesheet">
    
    <!-- Global site tag (gtag.js) - Google Analytics -->
    <script async src="https://www.googletagmanager.com/gtag/js?id=G-0B23113QGH"></script>
    <script>
      window.dataLayer = window.dataLayer || [];
      function gtag(){dataLayer.push(arguments);}
      gtag('js', new Date());
    
      gtag('config', 'G-0B23113QGH');
    </script>
</head>

<body>

<!-- ======= Header ======= -->
<header id="header" class="header fixed-top">
    <div class="container-fluid container-xl d-flex align-items-center justify-content-between">

       <a href="<?php echo isset($site_logo_link)&&!empty($site_logo_link)?$site_logo_link:'';?>" class="logo d-flex align-items-center">
        <!--<img src="assets/img/logo.png" alt="">-->
        <span><?php echo isset($site_logo_name)&&!empty($site_logo_name)?$site_logo_name:'';?></span>
      </a>
        <?php
        if(isset($promo_link) && !empty($promo_link)){
            ?>
            <nav id="navbar" class="navbar">
            <ul>
                <li><a class="getstarted scrollto" href="<?php echo $promo_link; ?>">Get Started</a></li>
            </ul>
            <i class="bi bi-list mobile-nav-toggle"></i>
            </nav><!-- .navbar -->
            <?php
        }else{
        }
        ?>
    </div>
</header><!-- End Header -->
  
<main id="main">
     <!--======= F.A.Q Section ======= -->
    <section id="faq" class="faq align-items-center mt-5 pt-4 pl-3 px-3">

      <div class="container">

        <header class="section-header">
          <!--<h2>F.A.Q</h2>-->
          <p><?php echo isset($page_title)&&!empty($page_title) ? $page_title : '' ;?></p>
        </header>

        <div class="row">
          <div class="col-lg-12 ">
            <?php echo isset($page_content)&&!empty($page_content) ? $page_content : '' ;?>
          </div>
        </div>

      </div>

    </section>
    <!-- End F.A.Q Section  -->
    
    <!-- Go to www.addthis.com/dashboard to customize your tools -->
    <script type="text/javascript" src="//s7.addthis.com/js/300/addthis_widget.js#pubid=ra-628791be07051feb"></script>


  </main>
  <!-- End #main -->
  <!-- ======= Footer ======= -->
  <!--<footer id="footer" class="footer">-->
  <!--  <div class="container">-->
  <!--    <div class="copyright">-->
  <!--      &copy; Copyright <strong><span>axe.link</span></strong>. All Rights Reserved-->
  <!--    </div>-->
  <!--  </div>-->
  <!--</footer>-->
   <!--End Footer -->
  <a href="#" class="back-to-top d-flex align-items-center justify-content-center"><i class="bi bi-arrow-up-short"></i></a>

  <!-- Vendor JS Files -->
  <script src="<?php echo base_url();?>assets/vendor/bootstrap/js/bootstrap.bundle.min.js"></script>
  <!-- Main JS File -->
  <script src="<?php echo base_url();?>assets/js/main.js"></script>
</body>
</html>