<?php
class admin_accounts_model extends CI_Model {
	
  	var $limit = 20;
	var $page = 1;
	var $pageConfig = array();
	var $errors = array();
	var $is_login = false;
	var $login_id = '';
	var $login_name = '';
	var $login_type = '';
	var $login_email = '';
	var $login_access = '';
	var $login_privileges = '';
	
	function __construct() {
		parent::__construct();
 		 if($this->input->cookie('perPage', TRUE)){
			 $this->limit = $this->input->cookie('perPage', TRUE);
 		 }
		 if($this->input->post('perPage',true)){
			setPageCookieMsg($this->input->post('perPage',true));
			redirect('admin/admin_accounts/sub_admins');
		 }
  		 if($this->input->get('per_page',true))$this->page = (int)$this->input->get('per_page') ; 
		 
		$this->setLoginVars();
  	}
	
	
	function setLoginVars() {
  		if($this->session->userdata('BIBLEALL_RP_ADMIN')){  
			$admSessData = $this->session->userdata('BIBLEALL_RP_ADMIN');
 			$this->is_login=true;
			$this->login_id = $admSessData['ID'];
			$this->login_name = $admSessData['USERNAME'];
			$this->login_type = $admSessData['USER_TYPE'];
			$this->login_email = $admSessData['EMAIL'];
			$this->login_access = $admSessData['ACCESS'];
			$this->login_privileges = $admSessData['PRIVILEGE'];
		}
	}

 	function getSubAdminList($resType = 'list'){
		$this->db->select('*');
		$this->db->from('accounts');
 		$this->db->where('accountDeleted',0); 
   		$this->db->where('accountId != ',$this->admin_model->login_id); 
		$this->db->where('(accountType = "Administrator" OR accountType = "SubAdmin")'); 
		if($this->input->get('searchKey',true) && $this->input->get('searchBy',true)){
			$this->db->like($this->input->get('searchBy',true),$this->input->get('searchKey',true)); 
		}
		if($this->input->get('searchStatus',true) && $this->input->get('searchStatus',true) == 'Enabled'){
 			$this->db->where('accountDisabled',0); 
		}else if($this->input->get('searchStatus',true) && $this->input->get('searchStatus',true) == 'Disabled'){
 			$this->db->where('accountDisabled',1); 
		}
		if($this->input->get('sortBy',true) && $this->input->get('sortOrder',true)){
 			$this->db->order_by($this->input->get('sortBy',true),$this->input->get('sortOrder',true)); 
		}else { 
			$this->db->order_by('accountCreated','desc'); 	
		}
 		if($resType == 'list'){
			if($this->page)$this->page = ($this->page-1);
			$this->db->limit($this->limit, ($this->page * $this->limit) ); 
			$query = $this->db->get(); //echo $this->db->last_query();
			if($query->num_rows()){return $query->result();}
			else return false;	
		}else{
			$query = $this->db->get();
			return $query->num_rows();
		} 
	}
	
	
	function getSubAdminList_For_Filter($resType = 'list'){
		$this->db->select('*');
		$this->db->from('accounts');
 		$this->db->where('accountDeleted',0); 
   	// 	$this->db->where('accountId != ',$this->admin_model->login_id); 
		$this->db->where('(accountType = "Administrator" OR accountType = "SubAdmin")');
		
		$this->db->where('accountDisabled',0);
		$this->db->order_by('accountCreated','desc');
		
 		if($resType == 'list'){
// 			if($this->page)$this->page = ($this->page-1);
			$this->db->limit(1000); 
			$query = $this->db->get(); //echo $this->db->last_query();
			if($query->num_rows()){return $query->result();}
			else return false;	
		}else{
			$query = $this->db->get();
			return $query->num_rows();
		}
	}
	
	 
	function doAdminAction($action,$ids){
		 
		if($action == 'delete'){ // $this->admin_model->login_id
 			$status = 'deleted';$logMsg = 'DeleteSubAdmins';
			$data = array( 'accountDeleted' => time());
			$successMsg= 'Sub admin(s) are deleted successfully';
			$this->db->where_in('accountId', $ids); $this->db->update('accounts', $data);
  		}else if($action == 'disable'){
 			$status = 'disabled';$logMsg = 'DisableSubAdmins';
			$data = array( 'accountDisabled' =>1 );$successMsg= 'Sub admin(s) are disabled successfully';
			 $this->db->where_in('accountId', $ids); $this->db->update('accounts', $data);
  		}else if($action == 'enable'){
 			$status = 'enabled';$logMsg = 'EnableSubAdmins';
			$data = array( 'accountDisabled' => 0 );$successMsg= 'Sub admin(s) are enabled successfully';
			 $this->db->where_in('accountId', $ids); $this->db->update('accounts', $data);
  		}	
		
		$arrPostData = array('action'=>$action,'accountId'=>$ids,);
		$arrTracking =array( 'log_type' => 'AdminActivity', 'log_status_msg'=> $logMsg, 'log_msg' => $successMsg,'log_request_data' =>  serialize($arrPostData), 'log_request_type' =>  'POST', );
 		$this->admin_model->tracking($arrTracking);	
 		
 		return $successMsg;
 		
	}
	
	function tracking($arrData) {
		 
		if(!isset($arrData['log_request_data'])){ 
 			$postData = $this->input->post();
			$getData = $this->input->get();
			if(!empty($postData)){ 
 			if(isset($postData['adminLoginPass'])){ $postData['adminLoginPass'] =  $this->encrypt->encrypt($postData['adminLoginPass'],'sadm');; }
 			$arrData['log_request_data']  = serialize($postData);$arrData['log_request_type'] =	'POST';
			}else if(!empty($getData)){ $arrData['log_request_data']  = serialize($getData);$arrData['log_request_type'] = 'GET'; }
		}
   		$arrData['log_account'] =	$this->login_id; 
  		$arrData['log_time'] =	time(); 
		$arrData['log_ip'] =	$this->input->ip_address();
		$arrData['log_ua'] =	$this->input->user_agent();
		$arrData['log_session'] =	$this->session->userdata('session_id');
		$arrData['log_referer_url'] =	$this->agent->referrer();
		$arrData['log_url'] =	current_url();
   		$this->db->insert('logs', $arrData); 
  	}
 	 
	 
}



