<?php
if (!defined('BASEPATH')) exit('No direct script access allowed');

class Home_model extends CI_Model {
    
    
    function validate_uniq_id($app_keyword = null){
        
        $this->db->select('id, app_keyword, target_type, destination_default_link, share_link, website_url, ios_app_store_url, android_play_store_url, sub_link_flag, main_link_id, utm_flag ');
		$this->db->from('app_share_link');
 		$this->db->where('is_active',0);
 		$this->db->where('is_deleted',0);
 		
 		if( !empty($app_keyword)){
 		    $this->db->where('app_keyword',$app_keyword);
 		}

 		$this->db->limit(1);
  		$query = $this->db->get();
  		
  		// echo $this->db->last_query();
  		// exit();
        $resArr=[];
  		if($query->num_rows() > 0){
  		    return $query->row();
  		}
		else return $resArr;
        
    }
    
    
    function get_country_redirects_data($link_id, $country_code ){
        
        $this->db->select('id, c_d_link');
		$this->db->from('country_redirects');
 		$this->db->where('is_active',0);
 		$this->db->where('is_deleted',0);
 		
 		if( !empty($link_id)){
 		    $this->db->where('link_id',$link_id);
 		}
 		if( !empty($country_code)){
 		    $this->db->where('country_code',$country_code);
 		}
 	    
 		$this->db->limit(1);
  		$query = $this->db->get();
  		
  		// echo $this->db->last_query();
  		// exit();
        $resArr=[];
        
  		if($query->num_rows() > 0){
  		    return $query->row();
  		}
		else return $resArr;
        
    }
    
    
    function get_rota_redir_links_list($link_id){
        
        $resArr=[];
        
        if( !empty($link_id)){
            
            $this->db->select('r_id');
    		$this->db->from('rotational_redirects');
     		$this->db->where('is_active',0);
     		$this->db->where('is_deleted',0);
     	
     	    $this->db->where( 'link_id' , $link_id );
     	    $this->db->order_by('r_id', 'ASC');

      		$query = $this->db->get();
      		// echo $this->db->last_query();
      		// exit();
            
      		if($query->num_rows() > 0){
                // $resArr_  = $query->result_array();
                // $resArr =  array_values($query->result_array());
                foreach($query->result() as $row ){
                    $resArr[] = $row->r_id;
                }
      		}
        }
       
        return $resArr;
        
    }
    
    
    function get_rota_redir_links_ROW($r_id){
         
        $resstr ='';  
        $this->db->select('r_link');
		$this->db->from('rotational_redirects');
 		$this->db->where('is_active',0);
 		$this->db->where('is_deleted',0);
 	    $this->db->where( 'r_id' , $r_id );
  		$query = $this->db->get();
  		if($query->num_rows() > 0){
            $resstr  = $query->row()->r_link;
  		}
        
        if(!empty($resstr)){
           return $resstr;
        }else{
            return "";
        }
        
    }
    
    function get_utm_row($link_id){
        
        $resArr = [];
        
        if(!empty($link_id)){
            $this->db->select('*');
    		$this->db->from('onelink_utm_tags');
     		$this->db->where('is_active',0);
     		$this->db->where('is_deleted',0);
     	    $this->db->where( 'link_id' , $link_id );
      		$query = $this->db->get();
      		if($query->num_rows() > 0){
                $resArr  = $query->row();
      		}
      		
        }
        
        return $resArr;
        
    }
    
    function get_rotational_redirects_data($link_id, $ip ){
        
        $final_r_link = '';
        
        if(!empty($link_id) && !empty($ip)){
            
            if(1){
                //check ip already hav
                $this->db->select('r_log_id, ip , r_ids');
        		$this->db->from('rotational_redir_logs');
         		$this->db->where('is_active',0);
         		$this->db->where('is_deleted',0);
         		
                $this->db->where('ip', $ip);
                $this->db->where('link_id', $link_id);
                
          		$query = $this->db->get();
          		// echo $this->db->last_query();
          		// exit();
                $log_r_row=[];
                
          		if($query->num_rows() > 0){
          		    $log_r_row = $query->row();
          		}
        		
        // 		var_dump($log_r_row);exit;
        		
        		$r_ids_already_exis=[];$r_log_id=false;
        		if(!empty($log_r_row)){
        		    //ip user already visit link
        		    $r_log_id = isset($log_r_row->r_log_id) && !empty($log_r_row->r_log_id) ? $log_r_row->r_log_id : "";
        		    $r_ids = isset($log_r_row->r_ids) && !empty($log_r_row->r_ids) ? $log_r_row->r_ids : "";
        		    
        		    if(!empty($r_log_id) && !empty($r_ids) ){
        		        $r_ids_already_exis = explode(',', $r_ids);
        		    }
        		}
        		
        		$avai_r_list = $this->get_rota_redir_links_list($link_id);
        				// var_dump($avai_r_list);exit;
        		
        		if(!empty($avai_r_list)){
        		    
        		    $result_sel_idA = $this->random_pick( $avai_r_list, $r_ids_already_exis);
    		    	 //   var_dump($result_sel_idA);exit;
        		    	
        		    if(isset($result_sel_idA->sel_id) &&  !empty($result_sel_idA->sel_id) ){
        		        
        		        $res_r_link = $this->get_rota_redir_links_ROW($result_sel_idA->sel_id);
        		        
        		        if(!empty($res_r_link)){
        		            $final_r_link = $res_r_link;
        		            
        		            $result_sel_id =  $result_sel_idA->sel_id;
        		            $r_ids_already_exis_RESET = $result_sel_idA->set_RESET_flag;
        		            
        		            //insert or update link in rlogtable
        		            $res_insert_update = $this->addEdit_rlog_Data($r_log_id, $link_id, $ip, $result_sel_id ,$r_ids_already_exis, $r_ids_already_exis_RESET);
        		            
        		        }
        		    }
        		}
        		
            }
            
        }
        
        // var_dump($final_r_link);exit;
       
        return $final_r_link;
    }
    
    function random_pick( $list_ids, $exclude_ids = [] ){
        
        // $resStr = "";
        // $set_RESET_flag =false;
        $resArr['sel_id']="";
        $resArr['set_RESET_flag']=false;
        
        if(!empty($exclude_ids)){
            $set_list_ids = array_diff($list_ids,$exclude_ids);
            if( empty($set_list_ids)){
                //if no diff means allvalues gettin last then reset list
                //set avai list
                $resArr['set_RESET_flag'] = true;
                $set_list_ids = $list_ids;
            }
            
        }else{
            $set_list_ids = $list_ids;
        }
        
        if(!empty($set_list_ids)){
            
            try{
                $resArr['sel_id'] = $set_list_ids[array_rand($set_list_ids, 1)];
            }
            catch(Exception $e) {
                // $resStr ="";
            }

        }
        
        return (object) $resArr;
        
    }
    
    function addEdit_rlog_Data( $r_log_id, $link_id, $ip, $r_id ,$r_ids_already_exis, $r_ids_already_exis_RESET){
        
        
        if(!empty($r_log_id)){
            //update
            
            $r_ids_str ='';
            if(  !$r_ids_already_exis_RESET && !empty($r_ids_already_exis)){
                $r_ids_already_exis = implode(',', $r_ids_already_exis);
                $r_ids_str = $r_ids_already_exis . ',' . $r_id;
            }
            else{
                $r_ids_str = $r_id;
            }
            
            
            $arr = array( 'r_ids' => $r_ids_str , 'link_id' => $link_id ,'ip' => $ip , 'updated_at' => date('Y-m-d H:i:s') );
            
            // var_dump($arr);
            // exit;
            
            $this->db->where( 'r_log_id' , $r_log_id);
            $res = $this->db->update( 'rotational_redir_logs',$arr);
            
            
        }else{
            
            $arr = array( 'r_ids' => $r_id , 'link_id' => $link_id ,'ip' => $ip , 'created_at' => date('Y-m-d H:i:s') );
            //insert 
            $res = $this->db->insert( 'rotational_redir_logs',$arr);
            if($res){
                $r_log_id = $this->db->insert_id();
            }else{
                $r_log_id =false;
            }
            
        }
        
        return $r_log_id;
        
    }
    
    function get_seolink_page_data($link_id){
        
        $resstr = '';
        if(!empty($link_id)){
            
            $this->db->select('id, page_slug');
    		$this->db->from('links_page_seo');
     		$this->db->where('is_active',0);
     		$this->db->where('is_deleted',0);
     	    $this->db->where( 'link_id' , $link_id );
      		$query = $this->db->get();
      		
      		if($query->num_rows() > 0){
                if(!empty($query->row()->page_slug)){
                    $resstr  = $query->row()->page_slug;
                }
      		}
      		
        }
        
        return $resstr;
        
    }
    
}