<?php
if (!defined('BASEPATH')) exit('No direct script access allowed');

class Visit_log_model extends CI_Model {
    
    
    private $sys = null;
	
	public function __construct(){
		$this->sys	=& get_instance();
        $this->sys->load->library('user_agent');
        $this->save_site_visit();
	}
	
	private static function get_ip_address(){		
		$ip = getenv('HTTP_CLIENT_IP')?:
			getenv('HTTP_X_FORWARDED_FOR')?:
			getenv('HTTP_X_FORWARDED')?:
			getenv('HTTP_FORWARDED_FOR')?:
			getenv('HTTP_FORWARDED')?:
			getenv('REMOTE_ADDR');		
		return $ip;
	}
	
	private function get_page_visit(){
		return current_url();
	}
    
    private function get_user_agent(){    
        
        if ($this->sys->agent->is_browser()){
            $agent = $this->sys->agent->browser().' '.$this->sys->agent->version();
        }
        elseif ($this->sys->agent->is_robot()){
            $agent = $this->sys->agent->robot();
        }
        elseif ($this->sys->agent->is_mobile()){
            $agent = $this->sys->agent->mobile();
        }
        else{
            $agent = 'Unidentified User Agent';
        }

        return $agent;
    }
	
	private function get_os_platform()
    {
        $user_agent = $_SERVER['HTTP_USER_AGENT'];
        $os_platform  = "Unknown OS Platform";

        $os_array     = array(
                          '/windows nt 10/i'      =>  'Windows 10',
                          '/windows nt 6.3/i'     =>  'Windows 8.1',
                          '/windows nt 6.2/i'     =>  'Windows 8',
                          '/windows nt 6.1/i'     =>  'Windows 7',
                          '/windows nt 6.0/i'     =>  'Windows Vista',
                          '/windows nt 5.2/i'     =>  'Windows Server 2003/XP x64',
                          '/windows nt 5.1/i'     =>  'Windows XP',
                          '/windows xp/i'         =>  'Windows XP',
                          '/windows nt 5.0/i'     =>  'Windows 2000',
                          '/windows me/i'         =>  'Windows ME',
                          '/win98/i'              =>  'Windows 98',
                          '/win95/i'              =>  'Windows 95',
                          '/win16/i'              =>  'Windows 3.11',
                          '/macintosh|mac os x/i' =>  'Mac OS X',
                          '/mac_powerpc/i'        =>  'Mac OS 9',
                          '/linux/i'              =>  'Linux',
                          '/ubuntu/i'             =>  'Ubuntu',
                          '/iphone/i'             =>  'iPhone',
                          '/ipod/i'               =>  'iPod',
                          '/ipad/i'               =>  'iPad',
                          '/android/i'            =>  'Android',
                          '/blackberry/i'         =>  'BlackBerry',
                          '/webos/i'              =>  'Mobile'
                        );

        foreach ($os_array as $regex => $value)
            if (preg_match($regex, $user_agent))
                $os_platform = $value;
        
        
        $windows_os_array = array('Windows 10','Windows 8.1', 'Windows 8', 'Windows 7', 'Windows Vista', 'Windows Server 2003/XP x64', 'Windows XP', 'Windows XP',
                                'Windows 2000', 'Windows ME', 'Windows 98', 'Windows 95', 'Windows 3.11');
        
        $ios_os_array = array('Mac OS X','Mac OS 9', 'iPhone', 'iPod', 'iPad');
        $android_os_array = array('Android','Mobile');
        $ubuntu_os_array = array('Linux','Ubuntu');
        $blackberry_os_array = array('BlackBerry');
                
        if(in_array($os_platform , $windows_os_array))
        {
            $os_platform = 'Windows';
        }
        else if(in_array($os_platform , $ios_os_array))
        {
            $os_platform = 'IOS';
        }
        else if(in_array($os_platform , $android_os_array))
        {
            $os_platform = 'Android';
        }
        else if(in_array($os_platform , $ubuntu_os_array))
        {
            $os_platform = 'Ubuntu';
        }
        else if(in_array($os_platform , $blackberry_os_array))
        {
            $os_platform = 'BlackBerry';
        }
        else 
        {
            $os_platform = 'Unknown Platform';
        }
        
        return $os_platform;
    }
    
    // private function 
    
	public function save_site_visit(){
	    
		$ip = self::get_ip_address();
		$cur_url = self::get_page_visit();
        $agent = self::get_user_agent();
        $os = $this->agent->platform();
        
        $user_agent_str = $this->agent->agent_string();
        
        $referrer_url = $this->agent->referrer();
        
        //Uncomment the IF Statement if you do not want your own admin pages to be tracked. Change the value of the needle ('admin) to the segments (URI) found in your admin pages.
		//if(!in_array('admin', $seg)){
			$data = array(
				'ip'            => $ip,
				'log_url'       => $cur_url,
                'user_agent_str'=> $user_agent_str,
                'user_agent'    => $agent,
                'os_platform'   => $os,
                'referer_url'  => $referrer_url,
				'created_at'    => date('Y-m-d H:i:s')
			);
			
			$this->sys->db->insert('visitor_log', $data);			
		//}
	}
	
}